/**
 * Content script - runs in the context of web pages
 * 
 * Minimal footprint, only activates when Cynthia needs to interact.
 */

// Listen for messages from background script
chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
  if (msg.type === 'ping') {
    sendResponse({ status: 'ok' });
  }
  return true;
});

// Log that we're loaded (for debugging)
console.log('[Cynthia] Browser extension content script loaded');
